<?php
extract(shortcode_atts(array(

    'testimonial_item' => '',
    'title_color' => '',
    'content_color' => '',
    'position_color' => '',
    'el_class' => '',

), $atts));

wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'murtes-carousel' );
$html_id = cmsHtmlID('ct-testimonial-carousel');
extract(murtes_get_param_carousel($atts));
$testimonials = (array) vc_param_group_parse_atts($testimonial_item);
if(!empty($testimonials)) : ?>
    <div id="<?php echo esc_attr($html_id);?>" class="ct-testimonial ct-testimonial-carousel1 owl-carousel <?php echo esc_attr( $el_class ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
        <?php foreach ($testimonials as $key => $value) {
            $title = isset($value['title']) ? $value['title'] : '';
            $position = isset($value['position']) ? $value['position'] : '';
            $content = isset($value['content']) ? $value['content'] : '';
            $image = isset($value['image']) ? $value['image'] : '';
            $img = wpb_getImageBySize( array(
                'attach_id'  => $image,
                'thumb_size' => '370x440',
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            $rating = isset($value['rating']) ? $value['rating'] : ''; ?>
            <div class="testimonial-item">
                <?php if(!empty($image)) { ?>
                    <div class="testimonial-featured">
                        <?php echo wp_kses_post($thumbnail); ?>
                    </div>
                <?php } ?>
                <div class="testimonial-holder">
                    <div class="testimonial-rating <?php echo esc_attr($rating); ?>">
                        <span></span>
                        <span></span>
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                    <div class="testimonial-content" style="<?php if(!empty($content_color)) { echo 'color:'.esc_attr($content_color).';'; } ?>"><?php echo wp_kses_post($content); ?></div>
                    <h3 class="testimonial-title" style="<?php if(!empty($title_color)) { echo 'color:'.esc_attr($title_color).';'; } ?>"><?php echo esc_attr($title); ?></h3>
                    <div class="testimonial-position" style="<?php if(!empty($position_color)) { echo 'color:'.esc_attr($position_color).';'; } ?>"><?php echo esc_attr($position); ?></div>
                </div>
            </div>
        <?php } ?>
    </div>
<?php endif;?>