<?php
$atts_extra = shortcode_atts(array(
    'source'               => '',
    'orderby'              => 'date',
    'order'                => 'DESC',
    'limit'                => '6',
    'post_ids'             => '',
    'img_size'             => '600x333',
    'el_class'             => '',
    'length_excerpt'             => '19',
), $atts);
$atts = array_merge($atts_extra, $atts);
extract($atts);
extract(cms_get_posts_of_grid('service', $atts));
extract(murtes_get_param_carousel($atts));
wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'murtes-carousel' );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-grid ct-carousel-service2 owl-carousel <?php echo esc_attr($el_class); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>

    <?php
    if (is_array($posts)):
        foreach ($posts as $key => $post) {
            the_post(); 
            $img_id = get_post_thumbnail_id($post->ID);
            $img = wpb_getImageBySize( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            $service_excerpt = get_post_meta($post->ID, 'service_excerpt', true);
            $first_title = strtok(get_the_title($post->ID), " ");
            $link_custom = get_post_meta($post->ID, 'link_custom', true);
            ?>
            <div class="ct-carousel-item">
                <div class="grid-item-inner">
                    <div class="item-count"><?php if($key < 9) { echo '0'; } echo esc_attr($key+1); ?>.</div>
                    <div class="item-body">
                        <h3 class="item-title">
                            <a href="<?php if(!empty($link_custom)) { echo esc_url($link_custom); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <?php echo esc_attr($first_title); ?><br/>
                                <?php echo ltrim(get_the_title($post->ID), $first_title); ?>
                            </a>
                        </h3>
                        <div class="item-content">
                            <?php echo wp_trim_words( $service_excerpt, $num_words = $length_excerpt, $more = null ); ?>
                        </div>
                        <div class="item-more">
                            <a href="<?php if(!empty($link_custom)) { echo esc_url($link_custom); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <?php if(!empty($readmore_text)) {
                                    echo esc_attr($readmore_text);
                                } else {
                                    echo esc_html__('Details', 'murtes');
                                } ?>
                                <i class="icofont-long-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        <?php }
    endif; ?>
    
</div>