<?php
$atts_extra = shortcode_atts(array(
    'source'               => '',
    'orderby'              => 'date',
    'order'                => 'DESC',
    'limit'                => '6',
    'post_ids'             => '',
    'img_size'             => '600x292',
    'el_class'             => '',
    'length_excerpt'             => '19',
    'row'         => '2',
), $atts);
$atts = array_merge($atts_extra, $atts);
extract($atts);
extract(cms_get_posts_of_grid('case-study', $atts));
extract(murtes_get_param_carousel($atts));
wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'murtes-carousel' );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
$counter = 0;
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-grid ct-case-study-carousel4 owl-carousel <?php echo esc_attr($el_class); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>

    <?php
    if (is_array($posts)):
        foreach ($posts as $key => $post) {
            the_post(); 
            $img_id = get_post_thumbnail_id($post->ID);
            $img = wpb_getImageBySize( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            $first_title = strtok(get_the_title($post->ID), " ");
            $count_title = str_word_count(get_the_title($post->ID));
            $counter++;
            if($row == 1){
                echo '<div class="cms-carousel-item-wrap">';
            }else{
                if($counter % $row == 1){
                    echo '<div class="cms-carousel-item-wrap">';
                }
            }
            ?>
            <div class="ct-carousel-item">
                <div class="grid-item-inner">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) { ?>
                        <div class="item-featured">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                        </div>
                        <div class="item-body">
                            <h3 class="item-title">
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <?php if($count_title == 2) {
                                        echo esc_attr($first_title).'<br/>';
                                        echo ltrim(get_the_title($post->ID), $first_title);
                                    } else {
                                        echo esc_attr(get_the_title($post->ID));
                                    } ?>
                                </a>
                            </h3>
                            <div class="item-category"><?php the_terms( $post->ID, 'case-study-category', '', ', ' ); ?></div>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <?php if($row == 1){
                echo '</div>';
            } else {
                if($counter % $row == 0){
                    echo '</div>';
                }
            }
        }
    endif; ?>
    
</div>