<?php
$atts_extra = shortcode_atts(array(
    'source'               => '',
    'orderby'              => 'date',
    'order'                => 'DESC',
    'limit'                => '6',
    'post_ids'             => '',
    'img_size'             => '600x344',
    'el_class'             => '',
    'length_excerpt'             => '19',
), $atts);
$atts = array_merge($atts_extra, $atts);
extract($atts);
extract(cms_get_posts_of_grid('post', $atts));
extract(murtes_get_param_carousel($atts));
wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'murtes-carousel' );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-grid ct-carousel-blog1 owl-carousel <?php echo esc_attr($el_class); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>

    <?php
    if (is_array($posts)):
        foreach ($posts as $key => $post) {
            the_post(); 
            $img_id = get_post_thumbnail_id($post->ID);
            $img = wpb_getImageBySize( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            global $current_user;
            ?>
            <div class="ct-carousel-item">
                <div class="grid-item-inner">
                    <div class="item-body">
                        <h3 class="item-title">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                        </h3>
                        <div class="item-content">
                            <?php echo wp_trim_words( $post->post_excerpt, $num_words = $length_excerpt, $more = null ); ?>
                        </div>
                    </div>
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) { ?>
                        <div class="item-featured">
                            <a  href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </a>
                        </div>
                    <?php } ?>
                    <ul class="item-meta">
                        <li class="item-author">
                            <i class="icofont-user-alt-7"></i><span><?php echo esc_html__('By', 'murtes'); ?></span>&nbsp;<?php the_author_posts_link(); ?>
                        </li>
                        <li class="item-date"><i class="icofont-ui-calendar"></i><?php echo get_the_date(); ?></li>
                    </ul>
                </div>
            </div>
        <?php }
    endif; ?>
    
</div>