<?php
vc_map(array(
    'name' => 'Text Block',
    'base' => 'ct_text_block',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Text Displayed', 'murtes' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
    'params' => array(
        array(
            'type' => 'textarea_html',
            'heading' => esc_html__('Content', 'murtes'),
            'param_name' => 'content',
            'description' => 'Enter content.',
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Content Align', 'murtes'),
            'param_name' => 'content_align',
            'value' => array(
                'Left' => 'text-left',
                'Center' => 'text-center',
                'Right' => 'text-right',
            ),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Content Type', 'murtes'),
            'param_name' => 'content_type',
            'value' => array(
                'Default' => 'content-default',
                'List' => 'content-list',
                'Gradient' => 'text-gradient',
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Content Color', 'murtes'),
            'param_name' => 'content_color',
            'value' => '',
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Font Size', 'murtes'),
            'param_name' => 'font_size',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-4 vc_column',
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Line Height', 'murtes'),
            'param_name' => 'line_height',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-4 vc_column',
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Font Weight', 'murtes'),
            'param_name' => 'font_weight',
            'value' => array(
                'Default (Medium)' => '',
                'Normal' => 'fw400',
                'SemiBold' => 'fw600',
                'Bold' => 'fw700',
            ),
            'edit_field_class' => 'vc_col-sm-4 vc_column',
        ),

        /* Extra */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'murtes' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
            'group'            => esc_html__('Extra', 'murtes')
        ),
    )
));

class WPBakeryShortCode_ct_text_block extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>