<?php
$args = array(
    'name' => 'Team Carousel',
    'base' => 'ct_team_carousel',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Team Displayed', 'murtes' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
    'params' => array(

        /* Template */
        array(
            'type' => 'cms_template_img',
            'param_name' => 'cms_template',
            'shortcode' => 'ct_team_carousel',
            'heading' => esc_html__('Shortcode Template', 'murtes'),
            'admin_label' => true,
            'std' => 'ct_team_carousel.php',
            'group' => esc_html__('Template', 'murtes'),
        ),

        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'murtes' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
            'group'            => esc_html__('Template', 'murtes')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'murtes' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'murtes' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Template', 'murtes'),
        ),
        
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Content', 'murtes' ),
            'param_name' => 'content_list',
            'description' => esc_html__( 'Enter values for team item', 'murtes' ),
            'value' => '',
            'group' => esc_html__('Source Settings', 'murtes'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'ct_team_carousel.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'murtes' ),
                    'param_name' => 'image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'murtes' ),
                    'group' => esc_html__('Source Settings', 'murtes'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'murtes'),
                    'param_name' => 'title',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'murtes'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Position', 'murtes'),
                    'param_name' => 'position',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'murtes'),
                ),
                array(
                    'type' => 'vc_link',
                    'class' => '',
                    'heading' => esc_html__('Link Video', 'murtes'),
                    'param_name' => 'link_video',
                    'value' => '',
                    'group' => esc_html__('Source Settings', 'murtes')
                ),
            ),
        ),

        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Content', 'murtes' ),
            'param_name' => 'content_list_l2',
            'description' => esc_html__( 'Enter values for team item', 'murtes' ),
            'value' => '',
            'group' => esc_html__('Source Settings', 'murtes'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'ct_team_carousel--layout2.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'murtes' ),
                    'param_name' => 'image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'murtes' ),
                    'group' => esc_html__('Source Settings', 'murtes'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'murtes'),
                    'param_name' => 'title',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'murtes'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Position', 'murtes'),
                    'param_name' => 'position',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'murtes'),
                ),
                array(
                    'type' => 'vc_link',
                    'class' => '',
                    'heading' => esc_html__('Link Item Details', 'murtes'),
                    'param_name' => 'link_item_detail',
                    'value' => '',
                    'group' => esc_html__('Source Settings', 'murtes')
                ),
            ),
        ),

        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Content', 'murtes' ),
            'param_name' => 'content_list_l3',
            'description' => esc_html__( 'Enter values for team item', 'murtes' ),
            'value' => '',
            'group' => esc_html__('Source Settings', 'murtes'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'ct_team_carousel--layout3.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'murtes' ),
                    'param_name' => 'image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'murtes' ),
                    'group' => esc_html__('Source Settings', 'murtes'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'murtes'),
                    'param_name' => 'title',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'murtes'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Position', 'murtes'),
                    'param_name' => 'position',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'murtes'),
                ),
                array(
                    'type' => 'param_group',
                    'heading' => esc_html__( 'Social', 'murtes' ),
                    'param_name' => 'social',
                    'description' => esc_html__( 'Enter values for team item', 'murtes' ),
                    'value' => '',
                    'group' => esc_html__('Source Settings', 'murtes'),
                    'params' => array(
                        array(
                            'type' => 'iconpicker',
                            'heading' => esc_html__( 'Icon', 'murtes' ),
                            'param_name' => 'icon',
                            'value' => '',
                            'settings' => array(
                                'emptyIcon' => true,
                                'type' => 'fontawesome',
                                'iconsPerPage' => 200,
                            ),
                            'description' => esc_html__( 'Select icon from library.', 'murtes' ),
                            'admin_label' => true,
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' =>esc_html__('Link', 'murtes'),
                            'param_name' => 'social_link',
                            'admin_label' => true,
                        ),
                    ),
                ),
            ),
        ),

        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Image size', 'murtes' ),
            'param_name' => 'img_size',
            'value' => '',
            'description' => esc_html__( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).', 'murtes' ),
            'group'      => esc_html__('Source Settings', 'murtes'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'ct_team_carousel.php',
                )
            ),
        ),


    ));

$args = murtes_add_vc_extra_param($args);
vc_map($args);

class WPBakeryShortCode_ct_team_carousel extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>