<?php
vc_map(array(
    'name' => 'Google Map',
    'base' => 'ct_googlemap',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Google Map Displayed', 'murtes' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
    'params' => array(
        array(
            'type' => 'textfield',
            'heading' => esc_html__('API Key', 'murtes'),
            'param_name' => 'api',
            'value' => '',
            'description' => esc_html__('Enter you api key of map, get key from (//console.developers.google.com)', 'murtes')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Address', 'murtes'),
            'param_name' => 'address',
            'value' => 'New York, United States',
            'description' => esc_html__('Enter address of Map', 'murtes')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Coordinate', 'murtes'),
            'param_name' => 'coordinate',
            'value' => '',
            'description' => esc_html__('Enter coordinate of Map, format input (latitude, longitude)', 'murtes')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Click Show Info window', 'murtes'),
            'param_name' => 'infoclick',
            'value' => array(
                esc_html__('Yes, please', 'murtes') => true
            ),
            'description' => esc_html__('Click a marker and show info window (Default Show).', 'murtes')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Marker Coordinate', 'murtes'),
            'param_name' => 'markercoordinate',
            'value' => '',
            'description' => esc_html__('Enter marker coordinate of Map, format input (latitude, longitude)', 'murtes')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Marker Title', 'murtes'),
            'param_name' => 'markertitle',
            'value' => '',
            'description' => esc_html__('Enter Title Info windows for marker', 'murtes')
        ),
        array(
            'type' => 'textarea',
            'heading' => esc_html__('Marker Description', 'murtes'),
            'param_name' => 'markerdesc',
            'value' => '',
            'description' => esc_html__('Enter Description Info windows for marker', 'murtes')
        ),
        array(
            'type' => 'attach_image',
            'heading' => esc_html__('Marker Icon', 'murtes'),
            'param_name' => 'markericon',
            'value' => '',
            'description' => esc_html__('Select image icon for marker', 'murtes')
        ),
        array(
            'type' => 'textarea_raw_html',
            'heading' => esc_html__('Marker List', 'murtes'),
            'param_name' => 'markerlist',
            'value' => '',
            'description' => esc_html__('[{"coordinate":"41.058846,-73.539423","icon":"","title":"title demo 1","desc":"desc demo 1"},{"coordinate":"40.975699,-73.717636","icon":"","title":"title demo 2","desc":"desc demo 2"},{"coordinate":"41.082606,-73.469718","icon":"","title":"title demo 3","desc":"desc demo 3"}]', 'murtes')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Info Window Max Width', 'murtes'),
            'param_name' => 'infowidth',
            'value' => '200',
            'description' => esc_html__('Set max width for info window', 'murtes')
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Map Type', 'murtes'),
            'param_name' => 'type',
            'value' => array(
                'ROADMAP' => 'ROADMAP',
                'HYBRID' => 'HYBRID',
                'SATELLITE' => 'SATELLITE',
                'TERRAIN' => 'TERRAIN'
            ),
            'description' => esc_html__('Select the map type.', 'murtes')
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Style Template', 'murtes'),
            'param_name' => 'style',
            'value' => array(
                'Default' => '',
                'Custom' => 'custom',
                'Light Mmurteschrome' => 'light-mmurteschrome',
                'Blue water' => 'blue-water',
                'Midnight Commander' => 'midnight-commander',
                'Paper' => 'paper',
                'Red Hues' => 'red-hues',
                'Hot Pink' => 'hot-pink'
            ),
            'description' => 'Select your heading size for title.'
        ),
        array(
            'type' => 'textarea_raw_html',
            'heading' => esc_html__('Custom Template', 'murtes'),
            'param_name' => 'content',
            'value' => '',
            'description' => esc_html__('Get template from //snazzymaps.com', 'murtes'),
            'dependency' => array(
                'element'=>'style',
                'value'=>array(
                    'custom',
                )
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Zoom', 'murtes'),
            'param_name' => 'zoom',
            'value' => '13',
            'description' => esc_html__('zoom level of map, default is 13', 'murtes')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Width', 'murtes'),
            'param_name' => 'width',
            'value' => 'auto',
            'description' => esc_html__('Width of map without pixel, default is auto', 'murtes')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Height', 'murtes'),
            'param_name' => 'height',
            'value' => '350px',
            'description' => esc_html__('Height of map without pixel, default is 350px', 'murtes')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Scroll Wheel', 'murtes'),
            'param_name' => 'scrollwheel',
            'value' => array(
                esc_html__('Yes, please', 'murtes') => true
            ),
            'description' => esc_html__('If false, disables scrollwheel zooming on the map. The scrollwheel is disable by default.', 'murtes')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Pan Control', 'murtes'),
            'param_name' => 'pancontrol',
            'value' => array(
                esc_html__('Yes, please', 'murtes') => true
            ),
            'description' => esc_html__('Show or hide Pan control.', 'murtes')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Zoom Control', 'murtes'),
            'param_name' => 'zoomcontrol',
            'value' => array(
                esc_html__('Yes, please', 'murtes') => true
            ),
            'description' => esc_html__('Show or hide Zoom Control.', 'murtes')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Scale Control', 'murtes'),
            'param_name' => 'scalecontrol',
            'value' => array(
                esc_html__('Yes, please', 'murtes') => true
            ),
            'description' => esc_html__('Show or hide Scale Control.', 'murtes')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Map Type Control', 'murtes'),
            'param_name' => 'maptypecontrol',
            'value' => array(
                esc_html__('Yes, please', 'murtes') => true
            ),
            'description' => esc_html__('Show or hide Map Type Control.', 'murtes')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Street View Control', 'murtes'),
            'param_name' => 'streetviewcontrol',
            'value' => array(
                esc_html__('Yes, please', 'murtes') => true
            ),
            'description' => esc_html__('Show or hide Street View Control.', 'murtes')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Over View Map Control', 'murtes'),
            'param_name' => 'overviewmapcontrol',
            'value' => array(
                esc_html__('Yes, please', 'murtes') => true
            ),
            'description' => esc_html__('Show or hide Over View Map Control.', 'murtes')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'murtes' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
        ),
    )
));

class WPBakeryShortCode_ct_googlemap extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>