<?php
vc_map(array(
    'name' => 'Call To Action',
    'base' => 'ct_cta',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Call to action Displayed', 'murtes' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
    'params' => array(

        array(
            'type' => 'textarea',
            'heading' => esc_html__('Element Title', 'murtes'),
            'param_name' => 'title',
            'description' => 'Enter title.',
            'admin_label' => true,
        ),

        array(
            'type' => 'textarea',
            'heading' => esc_html__('Element Description', 'murtes'),
            'param_name' => 'desc',
            'description' => 'Enter description.',
        ),

        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Button Text', 'murtes' ),
            'param_name' => 'button_text',
            'value' => '',
            'admin_label' => true,
        ),
        array(
            'type' => 'vc_link',
            'class' => '',
            'heading' => esc_html__('Button Link', 'murtes'),
            'param_name' => 'button_link',
            'value' => '',
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Icon Library', 'murtes' ),
            'value' => array(
                esc_html__( 'Font Awesome 4', 'murtes' ) => 'fontawesome',
                esc_html__( 'Font Awesome 5', 'murtes' ) => 'fontawesome5',
                esc_html__( 'Material Design', 'murtes' ) => 'material_design',
                esc_html__( 'ET Line', 'murtes' ) => 'etline',
                esc_html__( 'Themify', 'murtes' ) => 'themify',
            ),
            'param_name' => 'icon_list',
            'description' => esc_html__( 'Select icon library.', 'murtes' ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon Material', 'murtes' ),
            'param_name' => 'icon_material_design',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'material-design',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'material_design',
            ),
            'description' => esc_html__( 'Select icon from library.', 'murtes' ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon FontAwesome 4', 'murtes' ),
            'param_name' => 'icon_fontawesome',
            'value' => '',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'fontawesome',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'fontawesome',
            ),
            'description' => esc_html__( 'Select icon from library.', 'murtes' ),
        ),  

        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon FontAwesome 5', 'murtes' ),
            'param_name' => 'icon_fontawesome5',
            'value' => '',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'awesome5',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'fontawesome5',
            ),
            'description' => esc_html__( 'Select icon from library.', 'murtes' ),
        ), 
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon ET Line', 'murtes' ),
            'param_name' => 'icon_etline',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'etline',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'etline',
            ),
            'description' => esc_html__( 'Select icon from library.', 'murtes' ),
        ),      
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon Themify', 'murtes' ),
            'param_name' => 'icon_themify',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'themify',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'themify',
            ),
            'description' => esc_html__( 'Select icon from library.', 'murtes' ),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Icon Weight', 'murtes'),
            'param_name' => 'icon_weight',
            'value' => array(
                'Solid' => '',
                'Regular' => 'icon-far',
                'Light' => 'icon-fal',
                'Brands' => 'icon-fab',
            ),
            'group' => esc_html__('Icon', 'murtes'),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'fontawesome5',
            ),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Icon Position', 'murtes'),
            'param_name' => 'icon_position',
            'value' => array(
                'Right' => 'icon-right',
                'Left' => 'icon-left',
            ),
            'group' => esc_html__('Icon', 'murtes'),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'fontawesome5',
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'murtes' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
            'group'            => esc_html__('Extra', 'murtes')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'murtes' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'murtes' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'murtes'),
        ),
    )
));

class WPBakeryShortCode_ct_cta extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>