<?php
vc_map(array(
    'name' => 'Counter',
    'base' => 'ct_counter',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Counter Displayed', 'murtes' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
    'params' => array(

        /* Template */
        array(
            'type' => 'cms_template_img',
            'param_name' => 'cms_template',
            'shortcode' => 'ct_counter',
            'heading' => esc_html__('Shortcode Template', 'murtes'),
            'std' => 'ct_counter.php',
            'group' => esc_html__('Template', 'murtes'),
        ),

        /* Title */
        array(
            'type' => 'textarea',
            'heading' => esc_html__('Title', 'murtes'),
            'param_name' => 'title',
            'description' => 'Enter title.',
            'group' => esc_html__('Title', 'murtes'),
            'admin_label' => true,
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Color', 'murtes'),
            'param_name' => 'title_color',
            'value' => '',
            'group' => esc_html__('Title', 'murtes'),
        ),

        /* Digit */
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Digit', 'murtes'),
            'param_name' => 'digit',
            'description' => 'Enter digit.',
            'group' => esc_html__('Digit', 'murtes'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Prefix', 'murtes'),
            'param_name' => 'prefix',
            'description' => 'Enter prefix.',
            'group' => esc_html__('Digit', 'murtes'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Suffix', 'murtes'),
            'param_name' => 'suffix',
            'description' => 'Enter suffix.',
            'group' => esc_html__('Digit', 'murtes'),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Color', 'murtes'),
            'param_name' => 'digit_color',
            'value' => '',
            'group' => esc_html__('Digit', 'murtes'),
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Use Grouping', 'murtes'),
            'param_name' => 'grouping',
            'value' => array(
                'No' => '0',
                'Yes' => '1',
            ),
            'group' => esc_html__('Digit', 'murtes'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Separator', 'murtes'),
            'param_name' => 'separator',
            'group' => esc_html__('Digit', 'murtes'),
            'dependency' => array(
                'element'=>'grouping',
                'value'=>array(
                    '1',
                )
            ),
        ),

        /* Icon */
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Icon Type', 'murtes'),
            'param_name' => 'icon_type',
            'value' => array(
                'Icon' => 'icon',
                'Image' => 'image',
            ),
            'group' => esc_html__('Icon', 'murtes'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'ct_counter.php',
                )
            ),
        ),
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Icon Image', 'murtes' ),
            'param_name' => 'icon_image',
            'value' => '',
            'description' => esc_html__( 'Select icon image from media library.', 'murtes' ),
            'dependency' => array(
                'element'=>'icon_type',
                'value'=>array(
                    'image',
                )
            ),
            'group' => esc_html__('Icon', 'murtes'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Icon Library', 'murtes' ),
            'value' => array(
                esc_html__( 'Font Awesome 4', 'murtes' ) => 'fontawesome',
                esc_html__( 'Font Awesome 5', 'murtes' ) => 'fontawesome5',
                esc_html__( 'Material Design', 'murtes' ) => 'material_design',
                esc_html__( 'Flaticon', 'murtes' ) => 'flaticon',
                esc_html__( 'ET Line', 'murtes' ) => 'etline',
                esc_html__( '7 Stroke', 'murtes' ) => 'pe7stroke',
            ),
            'param_name' => 'icon_list',
            'description' => esc_html__( 'Select icon library.', 'murtes' ),
            'dependency' => array(
                'element' => 'icon_type',
                'value' => 'icon',
            ),
            'group' => esc_html__('Icon', 'murtes'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon Material', 'murtes' ),
            'param_name' => 'icon_material_design',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'material-design',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'material_design',
            ),
            'description' => esc_html__( 'Select icon from library.', 'murtes' ),
            'group' => esc_html__('Icon', 'murtes'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon FontAwesome 4', 'murtes' ),
            'param_name' => 'icon_fontawesome',
            'value' => '',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'fontawesome',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'fontawesome',
            ),
            'description' => esc_html__( 'Select icon from library.', 'murtes' ),
            'group' => esc_html__('Icon', 'murtes'),
        ),  

        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon FontAwesome 5', 'murtes' ),
            'param_name' => 'icon_fontawesome5',
            'value' => '',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'awesome5',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'fontawesome5',
            ),
            'description' => esc_html__( 'Select icon from library.', 'murtes' ),
            'group' => esc_html__('Icon', 'murtes'),
        ), 
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Icon Weight', 'murtes'),
            'param_name' => 'icon_weight',
            'value' => array(
                'Solid' => '',
                'Regular' => 'icon-far',
                'Light' => 'icon-fal',
                'Brands' => 'icon-fab',
            ),
            'group' => esc_html__('Icon', 'murtes'),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'fontawesome5',
            ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Flaticon', 'murtes' ),
            'param_name' => 'icon_flaticon',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'flaticon',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'flaticon',
            ),
            'description' => esc_html__( 'Select icon from library.', 'murtes' ),
            'group' => esc_html__('Icon', 'murtes'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon ET Line', 'murtes' ),
            'param_name' => 'icon_etline',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'etline',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'etline',
            ),
            'description' => esc_html__( 'Select icon from library.', 'murtes' ),
            'group' => esc_html__('Icon', 'murtes'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon 7 Stroke', 'murtes' ),
            'param_name' => 'icon_pe7stroke',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'pe7stroke',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'pe7stroke',
            ),
            'description' => esc_html__( 'Select icon from library.', 'murtes' ),
            'group' => esc_html__('Icon', 'murtes'),
        ),

        /* Extra */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'murtes' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
            'group'            => esc_html__('Extra', 'murtes')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'murtes' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'murtes' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'murtes'),
        ),
    )
));

class WPBakeryShortCode_ct_counter extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>