<?php
    if(class_exists('WPCF7')) {
        $cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );

        $contact_forms = array();
        if ( $cf7 ) {
            foreach ( $cf7 as $cform ) {
                $contact_forms[ $cform->post_title ] = $cform->ID;
            }
        } else {
            $contact_forms[ esc_html__( 'No contact forms found', 'murtes' ) ] = 0;
        }

        vc_map(array(
            'name' => 'Contact Form',
            'base' => 'ct_contact_form',
            'class'    => 'ct-icon-element',
            'description' => esc_html__( 'Contact Form 7', 'murtes' ),
            'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
            'params' => array(

                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Layout', 'murtes'),
                    'param_name' => 'layout',
                    'value' => array(
                        'Layout 1' => 'layout1',
                        'Layout 2' => 'layout2',
                        'Layout 3' => 'layout3',
                        'Layout 4' => 'layout4',
                    ),
                ),

                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Select Contact Form', 'murtes' ),
                    'param_name' => 'id',
                    'value' => $contact_forms,
                    'save_always' => true,
                    'admin_label' => true,
                    'description' => esc_html__( 'Choose previously created contact form from the drop down list.', 'murtes' ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Sub Title', 'murtes' ),
                    'param_name' => 'sub_title',
                    'dependency' => array(
                        'element'=>'layout',
                        'value'=>array(
                            'layout1',
                        )
                    ),
                ),
                array(
                    'type' => 'textarea',
                    'heading' => esc_html__('Title', 'murtes'),
                    'param_name' => 'title',
                    'admin_label' => true,
                    'dependency' => array(
                        'element'=>'layout',
                        'value'=>array(
                            'layout1',
                            'layout3',
                            'layout4',
                        )
                    ),
                ),
                array(
                    'type' => 'textarea',
                    'heading' => esc_html__('Description', 'murtes'),
                    'param_name' => 'desc',
                    'dependency' => array(
                        'element'=>'layout',
                        'value'=>array(
                            'layout4',
                        )
                    ),
                ),
                /* Extra */
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Extra class name', 'murtes' ),
                    'param_name' => 'el_class',
                    'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
                    'group'      => esc_html__('Extra', 'murtes'),
                ),
                array(
                    'type' => 'animation_style',
                    'heading' => esc_html__( 'Animation Style', 'murtes' ),
                    'param_name' => 'animation',
                    'description' => esc_html__( 'Choose your animation style', 'murtes' ),
                    'admin_label' => false,
                    'weight' => 0,
                    'group' => esc_html__('Extra', 'murtes'),
                ),
            )
        ));

        class WPBakeryShortCode_ct_contact_form extends CmsShortCode
        {

            protected function content($atts, $content = null)
            {
                return parent::content($atts, $content);
            }
        }
    }
?>