<?php
vc_map(
    array(
        'name'     => esc_html__('Case Study Details', 'murtes'),
        'base'     => 'ct_case_study_detail',
        'class'    => 'ct-icon-element',
        'description' => esc_html__( 'Case Study Details Displayed', 'murtes' ),
        'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
        'params'   => array(
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Content', 'murtes' ),
                'param_name' => 'content_list',
                'description' => esc_html__( 'Enter values for case study detail item', 'murtes' ),
                'value' => '',
                'group' => esc_html__('Source Settings', 'murtes'),
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'heading' =>esc_html__('Title', 'murtes'),
                        'param_name' => 'title',
                        'admin_label' => true,
                        'group' => esc_html__('Source Settings', 'murtes'),
                    ),
                    array(
                        'type' => 'textarea',
                        'heading' =>esc_html__('Content', 'murtes'),
                        'param_name' => 'content',
                        'group' => esc_html__('Source Settings', 'murtes'),
                    ),
                    array(
                        'type' => 'iconpicker',
                        'heading' => esc_html__( 'Icon FontAwesome', 'murtes' ),
                        'param_name' => 'icon_fontawesome5',
                        'value' => '',
                        'settings' => array(
                            'emptyIcon' => true,
                            'type' => 'awesome5',
                            'iconsPerPage' => 200,
                        ),
                        'description' => esc_html__( 'Select icon from library.', 'murtes' ),
                    ),  

                    array(
                        'type' => 'dropdown',
                        'heading' => esc_html__('Icon Weight', 'murtes'),
                        'param_name' => 'icon_weight',
                        'value' => array(
                            'Solid' => '',
                            'Regular' => 'icon-far',
                            'Light' => 'icon-fal',
                            'Brands' => 'icon-fab',
                        ),
                    ),
                ),
            ),
            array(
                "type"             => "dropdown",
                "heading"          => esc_html__( "Columns XS", 'murtes' ),
                "param_name"       => "col_xs",
                "edit_field_class" => "ct-col-5",
                "value"            => array( 1, 2, 3, 4 ),
                "std"              => 1,
                "group"            => 'Column Settings',
            ),
            array(
                "type"             => "dropdown",
                "heading"          => esc_html__( "Columns SM", 'murtes' ),
                "param_name"       => "col_sm",
                "edit_field_class" => "ct-col-5",
                "value"            => array( 1, 2, 3, 4 ),
                "std"              => 2,
                "group"            => 'Column Settings',
            ),
            array(
                "type"             => "dropdown",
                "heading"          => esc_html__( "Columns MD", 'murtes' ),
                "param_name"       => "col_md",
                "edit_field_class" => "ct-col-5",
                "value"            => array( 1, 2, 3, 4, 5 ),
                "std"              => 3,
                "group"            => 'Column Settings',
            ),
            array(
                "type"             => "dropdown",
                "heading"          => esc_html__( "Columns LG", 'murtes' ),
                "param_name"       => "col_lg",
                "edit_field_class" => "ct-col-5",
                "value"            => array( 1, 2, 3, 4, 5, 6 ),
                "std"              => 3,
                "group"            => 'Column Settings',
            ),
            array(
                "type"             => "dropdown",
                "heading"          => esc_html__( "Columns XL", 'murtes' ),
                "param_name"       => "col_xl",
                "edit_field_class" => "ct-col-5",
                "value"            => array( 1, 2, 3, 4, 5, 6 ),
                "std"              => 3,
                "group"            => 'Column Settings',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'murtes' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
                'group'            => esc_html__('Extra', 'murtes')
            ),
            array(
                'type' => 'animation_style',
                'heading' => esc_html__( 'Animation Style', 'murtes' ),
                'param_name' => 'animation',
                'description' => esc_html__( 'Choose your animation style', 'murtes' ),
                'admin_label' => false,
                'weight' => 0,
                'group' => esc_html__('Extra', 'murtes'),
            ),
        )
    )
);

class WPBakeryShortCode_ct_case_study_detail extends CmsShortCode
{
    protected function content($atts, $content = null)
    {
        $html_id = cmsHtmlID('ct-grid-team');
        $atts['html_id'] = $html_id;
        return parent::content($atts, $content);
    }
}

?>