<?php
vc_map(array(
    'name' => 'Accordion',
    'base' => 'ct_accordion',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Collapsible content panels', 'murtes' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
    'params' => array(
        array(
            'type' => 'textfield',
            'heading' =>esc_html__('Active section', 'murtes'),
            'param_name' => 'active_section',
            'description' => 'Enter active section number (Note: to have all sections closed on initial load enter non-existing number).',
        ),
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Accordion Items', 'murtes' ),
            'param_name' => 'ct_accordion',
            'description' => esc_html__( 'Enter values for accordion item', 'murtes' ),
            'value' => '',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'murtes'),
                    'param_name' => 'ac_title',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'textarea',
                    'heading' =>esc_html__('Content', 'murtes'),
                    'param_name' => 'ac_content',
                ),
            ),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Styles', 'murtes'),
            'param_name' => 'style',
            'value' => array(
                'Style 1' => 'style1',
            ),
        ),

        /* Extra */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'murtes' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
            'group'            => esc_html__('Extra', 'murtes')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'murtes' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'murtes' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'murtes'),
        ),
    )
));

class WPBakeryShortCode_ct_accordion extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}
?>