<?php
/**
 * The template for displaying login form.
 *
 * Override this template by copying it to yourtheme/userpress/layoutname/form-login.php
 *
 * @author 		UserPress
 * @package 	UserPress/Templates
 * @version     1.0.0
 */

if (! defined ( 'ABSPATH' )) {
	exit (); // Exit if accessed directly
}
?>
<div class="user-press-login">
	<div class="login-form">
		<div class="fields-content">
			<div class="field-group">
				<input id="user" type="text" class="input user_name" placeholder="Username" data-validate="<?php esc_html_e('Required Field', 'murtes'); ?>">
			</div>
			<div class="field-group">
				<input id="pass" type="password" class="input password" placeholder="Password" data-validate="<?php esc_html_e('Required Field', 'murtes'); ?>">
			</div>
			<div class="field-group field-end">
				<button type="button" class="button button-login"><?php esc_html_e('Sign in', 'murtes');?></button>
				<div class="user-forget">
					<a class="forget" href="<?php echo wp_lostpassword_url(get_permalink()); ?>"><?php esc_html_e('Forgot your password ?', 'murtes') ?></a>
				</div>
				<div class="user-register-form">
					<span><?php echo esc_html__('Create an Account', 'murtes'); ?></span>
				</div>
			</div>
		</div>
	</div>
</div>
