<?php
$titles = murtes_get_page_titles();
ob_start();
if ( $titles['title'] )
{
    printf( '<h1 class="page-title">%s</h1>', esc_attr($titles['title']) );
}
$titles_html = ob_get_clean();
$ptitle_on = murtes_get_opt( 'ptitle_on', 'show');
$page_ptitle_on = murtes_get_page_opt( 'ptitle_on', 'themeoption');
if(is_page() && !empty($page_ptitle_on) && $page_ptitle_on != 'themeoption') {
	$ptitle_on = $page_ptitle_on;
} 
$ptitle_breadcrumb_on = murtes_get_opt( 'ptitle_breadcrumb_on', 'show' );
if(is_404()) {
    return true;
}
$ptitle_text_outline = murtes_get_opt( 'ptitle_text_outline' );
$page_title_outline = murtes_get_page_opt( 'ptitle_text_outline' );
if(!empty($page_title_outline)) {
	$ptitle_text_outline = $page_title_outline;
}

$p_btn_text = murtes_get_opt( 'p_btn_text' );
$p_btn_link_type = murtes_get_opt( 'p_btn_link_type', 'page' );
$p_btn_link = murtes_get_opt( 'p_btn_link' );
$p_btn_link_custom = murtes_get_opt( 'p_btn_link_custom' );
$p_btn_target = murtes_get_opt( 'p_btn_target', '_self' );
if($p_btn_link_type == 'page') {
    $p_btn_url = get_permalink($p_btn_link);
} else {
    $p_btn_url = $p_btn_link_custom;
}

?>
<?php if($ptitle_on == 'show') : ?>
	<div id="pagetitle" class="page-title bg-overlay">
	    <div class="container">
	        <div class="page-title-inner">
	            <?php printf( '%s', wp_kses_post($titles_html)); ?>
	            <?php if($ptitle_breadcrumb_on == 'show') : ?>
	            	<?php murtes_breadcrumb(); ?>
	            <?php endif; ?>
	            <?php if(!empty($p_btn_text)) : ?>
                    <a class="btn btn-page-title" href="<?php echo esc_url( $p_btn_url ); ?>" target="<?php echo esc_attr($p_btn_target); ?>"><?php echo esc_attr( $p_btn_text ); ?><i></i></a>
                <?php endif; ?>
	            <?php if(class_exists('ReduxFramework') && !empty($ptitle_text_outline)) : ?>
	            	<div class="ct-text-outline"><?php echo esc_attr($ptitle_text_outline); ?></div>
	            <?php endif; ?>
	        </div>
	    </div>
	</div>
<?php endif; ?>