<?php
/**
 * Template part for displaying default header layout
 */
$sticky_on = murtes_get_opt( 'sticky_on', false );
$search_on = murtes_get_opt( 'search_on', false );
$cart_on = murtes_get_opt( 'cart_on', false );
$user_on = murtes_get_opt( 'user_on', false );
$cart_on_mobile = murtes_get_opt( 'cart_on_mobile', false );
$h_email_address = murtes_get_opt( 'h_email_address' );
$short_text = murtes_get_opt( 'short_text' );

$h_btn_text = murtes_get_opt( 'h_btn_text' );
$h_btn_link_type = murtes_get_opt( 'h_btn_link_type', 'page' );
$h_btn_link = murtes_get_opt( 'h_btn_link' );
$h_btn_link_custom = murtes_get_opt( 'h_btn_link_custom' );
$h_btn_target = murtes_get_opt( 'h_btn_target', '_self' );
if($h_btn_link_type == 'page') {
    $h_btn_url = get_permalink($h_btn_link);
} else {
    $h_btn_url = $h_btn_link_custom;
}
?>
<header id="masthead" class="header-main">
    <div id="header-wrap" class="header-layout4 header-transparent <?php if($sticky_on == 1) { echo 'is-sticky'; } else { echo 'no-sticky'; } ?>">
        <div id="header-main" class="header-main">
            <div class="container">
                <div class="row">
                    <div class="header-branding">
                        <?php get_template_part( 'template-parts/header-branding' ); ?>
                    </div>
                    <div class="header-navigation">
                        <nav class="main-navigation">
                            <div class="main-navigation-inner">
                                <div class="menu-mobile-close"><i class="zmdi zmdi-close"></i></div>
                                <?php murtes_header_mobile_search(); ?>
                                <?php get_template_part( 'template-parts/header-menu' ); ?>
                                <?php if(!empty($h_btn_text)) : ?>
                                    <a class="menu-right-item btn btn-mobile" href="<?php echo esc_url( $h_btn_url ); ?>" target="<?php echo esc_attr($h_btn_target); ?>"><?php echo esc_attr( $h_btn_text ); ?><i></i></a>
                                <?php endif; ?>
                            </div>
                        </nav>
                        <div class="site-menu-right">
                            <?php if($search_on) : ?>
                                <span class="menu-right-item box-icon h-btn-search"><i class="icofont-search"></i></span>
                            <?php endif; ?>
                            <?php if(class_exists('Woocommerce') && $cart_on) : ?>
                                <div class="menu-right-item box-icon menu-cart">
                                    <span class="h-btn-cart"><i class="icofont-shopping-cart"></i><span class="cart-couter-items"><?php echo sprintf (_n( '%d', '%d', WC()->cart->cart_contents_count, 'murtes' ), WC()->cart->cart_contents_count ); ?></span></span>
                                    <div class="widget_shopping_cart">
                                        <div class="widget_shopping_cart_content">
                                            <?php woocommerce_mini_cart(); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if(function_exists('up_get_template_part') && $user_on): ?>
                                <div class="menu-right-item box-icon menu-user-icon">
                                    <span class="menu-user icofont-ui-user"><span class="menu-user-dot"></span></span>
                                    <div class="ct-form-user ct-form-login">
                                        <h3 class="form-heading">
                                            <?php
                                                if(is_user_logged_in()) {
                                                    echo esc_html__('My Account' ,'murtes');
                                                } else {
                                                    echo esc_html__('Login', 'murtes');
                                                }
                                            ?>
                                        </h3>
                                        <?php if(is_user_logged_in() && class_exists( 'Woocommerce' )) { 
                                            $myaccount_page = get_option( 'woocommerce_myaccount_page_id' );
                                            ?>
                                            <ul class="form-menu">
                                                <li><a href="<?php echo esc_url(get_permalink($myaccount_page)); ?>"><?php echo esc_html__('Account Dashboard', 'murtes'); ?></a></li>
                                                <li><a href="<?php echo esc_url(get_permalink($myaccount_page).'orders'); ?>"><?php echo esc_html__('My Orders', 'murtes'); ?></a></li>
                                            </ul>
                                        <?php } ?>
                                        <?php  echo do_shortcode('[user-press layout="" form_type="login" is_logged="profile"]'); ?>
                                    </div>
                                    <div class="ct-form-user ct-form-register">
                                        <h3 class="form-heading"><?php esc_html_e('Register','murtes'); ?></h3>
                                        <?php up_get_template_part('default/form', 'register'); ?>
                                    </div>
                                    
                                </div>
                            <?php endif; ?>
                            <?php if(!empty($h_email_address)) : ?>
                                <a class="menu-right-item box-icon" href="mailto:<?php echo esc_attr($h_email_address); ?>"><i class="icofont-envelope-open"></i></a>
                            <?php endif; ?>
                            <?php if(!empty($h_btn_text)) : ?>
                                <a class="menu-right-item btn btn-outline" href="<?php echo esc_url( $h_btn_url ); ?>" target="<?php echo esc_attr($h_btn_target); ?>"><?php echo esc_attr( $h_btn_text ); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="menu-mobile-overlay"></div>
                </div>
            </div>
            <div id="main-menu-mobile">
                <?php if (class_exists('Woocommerce') && $cart_on_mobile) : ?>
                    <div class="mobile-menu-cart">
                        <span class="h-btn-cart"><i class="far fac-shopping-cart"></i><span class="cart-couter-items"><?php echo sprintf (_n( '%d', '%d', WC()->cart->cart_contents_count, 'murtes' ), WC()->cart->cart_contents_count ); ?></span></span>
                        <div class="widget_shopping_cart">
                            <div class="widget_shopping_cart_content">
                                <?php woocommerce_mini_cart(); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <span class="btn-nav-mobile open-menu">
                    <span></span>
                </span>
            </div>
        </div>
    </div>
</header>