<?php
$footer_top_bar = murtes_get_opt('footer_top_bar', 'hidden'); 
$footer_copyright = murtes_get_opt('footer_copyright'); 
$footer_logo = murtes_get_opt('footer_logo'); 
$footer_text_outline = murtes_get_opt('footer_text_outline');
$cta = murtes_get_opt('cta', 'hidden');
$cta_subtitle = murtes_get_opt('cta_subtitle');
$cta_title = murtes_get_opt('cta_title');
$cta_btn_text = murtes_get_opt('cta_btn_text');
$cta_btn_link = murtes_get_opt('cta_btn_link');
$cta_btn_target = murtes_get_opt('cta_btn_target', '_self');
$cta_text_outline = murtes_get_opt('cta_text_outline');

$cta_page = murtes_get_page_opt('cta_page', 'themeoption');
if(!empty($cta_page) && $cta_page != 'themeoption') {
    $cta = $cta_page;
}
?>
<footer id="colophon" class="site-footer footer-layout1">
    <?php if($cta == 'show' && !empty($cta_btn_text)) : ?>
        <div class="cta-footer">
            <div class="container">
                <div class="row">
                    <div class="cta-holder">
                        <span class="cta-sub"><?php echo esc_attr($cta_subtitle); ?></span>
                        <h3 class="cta-title"><?php echo wp_kses_post($cta_title); ?></h3>
                    </div>
                    <?php if(!empty($cta_btn_text)) : ?>
                        <div class="cta-button">
                            <a class="btn" href="<?php echo esc_url($cta_btn_link); ?>"><?php echo esc_attr($cta_btn_text); ?><i class="icofont-long-arrow-right"></i></a>
                            <div class="ct-text-outline"><?php echo esc_attr($cta_text_outline); ?></div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <?php if ( is_active_sidebar( 'sidebar-footer-1' ) || is_active_sidebar( 'sidebar-footer-2' ) || is_active_sidebar( 'sidebar-footer-3' ) || is_active_sidebar( 'sidebar-footer-4' ) || is_active_sidebar( 'sidebar-footer-5' ) ) : ?>
        <div class="top-footer bg-image bg-overlay">
            <div class="container">
                <div class="row">
                    <?php murtes_footer_top(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <div class="bottom-footer">
        <div class="container">
            <div class="row">
                <div class="bottom-copyright">
                    <?php if ($footer_copyright) {
                        echo apply_filters('the_content', $footer_copyright);
                    } else {
                        echo wp_kses_post(''.esc_attr(date("Y")).' &copy; All rights reserved by <a target="_blank" href="//themeforest.net/user/case-themes/portfolio">CaseThemes</a>');
                    } ?>
                </div>
                <div class="bottom-social">
                    <?php murtes_social_icon(); ?>
                </div>
            </div>
        </div>
    </div>
</footer>