<?php
if (!class_exists('ReduxFramework')) {
    return;
}
if (class_exists('ReduxFrameworkPlugin')) {
    remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
}

if(class_exists('Newsletter')) {
    $forms = array_filter( (array) get_option( 'newsletter_forms', array() ) );

    $newsletter_forms = array(
        'default' => esc_html__( 'Default Form', 'murtes' )
    );

    if ( $forms )
    {
        $index = 1;
        foreach ( $forms as $key => $form )
        {
            $newsletter_forms[ $key ] = sprintf( esc_html__( 'Form %s', 'murtes' ), $index );
            $index ++;
        }
    }
} else {
    $newsletter_forms = '';
}

$opt_name = murtes_get_opt_name();
$theme = wp_get_theme();

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name'         => $theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version'      => $theme->get('Version'),
    // Version that appears at the top of your panel
    'menu_type'            => class_exists('CaseThemeCore') ? 'submenu' : '',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => esc_html__('Theme Options', 'murtes'),
    'page_title'           => esc_html__('Theme Options', 'murtes'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: //developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key'       => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => false,
    // Use a asynchrmurtesus font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => true,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-admin-generic',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => true,
    // Show the time the page took to load, etc
    'update_notice'        => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    'show_options_object' => false,
    // OPTIONAL -> Give you extra features
    'page_priority'        => null,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => class_exists('CaseThemeCore') ? $theme->get('TextDomain') : '',
    // For a full list of options, visit: //codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => 'theme-options',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints'                => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color'    => 'lightgray',
        'icon_size'     => 'normal',
        'tip_style'     => array(
            'color'   => 'red',
            'shadow'  => true,
            'rounded' => false,
            'style'   => '',
        ),
        'tip_position'  => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect'    => array(
            'show' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'mouseover',
            ),
            'hide' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'click mouseleave',
            ),
        ),
    ),
    'templates_path'       => class_exists('CaseThemeCore') ? casethemescore()->path('APP_DIR') . '/templates/redux/' : '',
);

Redux::SetArgs($opt_name, $args);

/*--------------------------------------------------------------
# General
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('General', 'murtes'),
    'icon'   => 'el-icon-home',
    'fields' => array(
        array(
            'id'       => 'show_page_loading',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Page Loading', 'murtes'),
            'subtitle' => esc_html__('Enable page loading effect when you load site.', 'murtes'),
            'default'  => false
        ),
        array(
            'id'       => 'loading_type',
            'type'     => 'select',
            'title'    => esc_html__('Loading Style', 'murtes'),
            'options'  => array(
                'style1'  => esc_html__('Style 1', 'murtes'),
                'style2'  => esc_html__('Style 2', 'murtes'),
                'style3'  => esc_html__('Style 3', 'murtes'),
                'style4'  => esc_html__('Style 4', 'murtes'),
                'style5'  => esc_html__('Style 5', 'murtes'),
                'style6'  => esc_html__('Style 6', 'murtes'),
                'style7'  => esc_html__('Style 7', 'murtes'),
                'style8'  => esc_html__('Style 8', 'murtes'),
                'style9'  => esc_html__('Style 9', 'murtes'),
            ),
            'default'  => 'style1',
            'required' => array( 0 => 'show_page_loading', 1 => 'equals', 2 => '1' ),
            'force_output' => true
        ),
        array(
            'id'       => 'smoothscroll',
            'type'     => 'switch',
            'title'    => esc_html__('Smooth Scroll', 'murtes'),
            'default'  => false
        ),
        array(
            'id'       => 'body_background',
            'type'     => 'background',
            'title'    => esc_html__('Body Boxed Background', 'murtes'),
            'required' => array( 0 => 'layout_boxed', 1 => 'equals', 2 => '1' ),
            'force_output' => true
        ),
        array(
            'id'       => 'dev_mode',
            'type'     => 'switch',
            'title'    => esc_html__('Dev Mode (not recommended)', 'murtes'),
            'description' => 'no minimize , generate css over time...',
            'default'  => false
        ),
        array(
            'id'       => 'favicon',
            'type'     => 'media',
            'title'    => esc_html__('Favicon', 'murtes'),
            'default' => ''
        ),
    )
));

/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Header', 'murtes'),
    'icon'   => 'el-icon-website',
    'fields' => array(
        array(
            'id'       => 'header_layout',
            'type'     => 'image_select',
            'title'    => esc_html__('Layout', 'murtes'),
            'subtitle' => esc_html__('Select a layout for header.', 'murtes'),
            'options'  => array(
                '1' => get_template_directory_uri() . '/assets/images/header-layout/h1.jpg',
                '2' => get_template_directory_uri() . '/assets/images/header-layout/h2.jpg',
                '3' => get_template_directory_uri() . '/assets/images/header-layout/h3.jpg',
                '4' => get_template_directory_uri() . '/assets/images/header-layout/h4.jpg',
                '5' => get_template_directory_uri() . '/assets/images/header-layout/h5.jpg',
            ),
            'default'  => '1'
        ),
        array(
            'id'       => 'search_on',
            'type'     => 'switch',
            'title'    => esc_html__('Search Popup', 'murtes'),
            'default'  => false
        ),
        array(
            'id'       => 'cart_on',
            'type'     => 'switch',
            'title'    => esc_html__('Cart Shop', 'murtes'),
            'default'  => false
        ),
        array(
            'id'       => 'user_on',
            'type'     => 'switch',
            'title'    => esc_html__('User Form', 'murtes'),
            'default'  => false
        ),
        array(
            'id'       => 'sticky_on',
            'type'     => 'switch',
            'title'    => esc_html__('Sticky Header', 'murtes'),
            'subtitle' => esc_html__('Header will be sticked when applicable.', 'murtes'),
            'default'  => false
        ),
        array(
            'id'       => 'search_background_color',
            'type'     => 'color_rgba',
            'title'    => esc_html__('Search Background Color Overlay', 'murtes'),
            'output' => array('background-color' => '.ct-modal.ct-search-popup'),
        ),
        array(
            'id' => 'h_phone_number',
            'type' => 'text',
            'title' => esc_html__('Phone Number', 'murtes'),
            'default' => '',
        ),
        array(
            'id' => 'h_email_address',
            'type' => 'text',
            'title' => esc_html__('Email Address', 'murtes'),
            'default' => '',
        ),
        array(
            'id' => 'short_text',
            'type' => 'text',
            'title' => esc_html__('Short Text', 'murtes'),
            'default' => '',
        ),
        array(
            'title' => esc_html__('Button Navigation', 'murtes'),
            'type'  => 'section',
            'id' => 'button_navigation',
            'indent' => true,
        ),
        array(
            'id' => 'h_btn_text',
            'type' => 'text',
            'title' => esc_html__('Button Text', 'murtes'),
            'default' => '',
        ),
        array(
            'id'       => 'h_btn_link_type',
            'type'     => 'button_set',
            'title'    => esc_html__('Button Link Type', 'murtes'),
            'options'  => array(
                'page'  => esc_html__('Page', 'murtes'),
                'custom'  => esc_html__('Custom', 'murtes')
            ),
            'default'  => 'page',
        ),
        array(
            'id'    => 'h_btn_link',
            'type'  => 'select',
            'title' => esc_html__( 'Page Link', 'murtes' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'h_btn_link_type', 1 => 'equals', 2 => 'page' ),
            'force_output' => true
        ),
        array(
            'id' => 'h_btn_link_custom',
            'type' => 'text',
            'title' => esc_html__('Custom Link', 'murtes'),
            'default' => '',
            'required' => array( 0 => 'h_btn_link_type', 1 => 'equals', 2 => 'custom' ),
            'force_output' => true
        ),
        array(
            'id'       => 'h_btn_target',
            'type'     => 'button_set',
            'title'    => esc_html__('Button Target', 'murtes'),
            'options'  => array(
                '_self'  => esc_html__('Self', 'murtes'),
                '_blank'  => esc_html__('Blank', 'murtes')
            ),
            'default'  => '_self',
        ),
    )
));


Redux::setSection($opt_name, array(
    'title'      => esc_html__('Logo', 'murtes'),
    'icon'       => 'el el-picture',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'logo',
            'type'     => 'media',
            'title'    => esc_html__('Logo Dark', 'murtes'),
            'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/logo-dark.png'
            )
        ),
        array(
            'id'       => 'logo_light',
            'type'     => 'media',
            'title'    => esc_html__('Logo Light', 'murtes'),
            'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/logo-light.png'
            )
        ),
        array(
            'id'       => 'logo_maxh',
            'type'     => 'dimensions',
            'title'    => esc_html__('Logo Max height', 'murtes'),
            'subtitle' => esc_html__('Set maximum height for your logo.', 'murtes'),
            'width'    => false,
            'unit'     => 'px'
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Navigation', 'murtes'),
    'icon'       => 'el el-lines',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'          => 'font_menu',
            'type'        => 'typography',
            'title'       => esc_html__('Custom Google Font', 'murtes'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'font-style'  => false,
            'font-weight'  => false,
            'text-align'  => false,
            'font-size'  => false,
            'line-height'  => false,
            'color'  => false,
            'output'      => array('.primary-menu li a'),
            'units'       => 'px',
        ),
        array(
            'id'       => 'menu_font_size',
            'type'     => 'text',
            'title'    => esc_html__('Font Size', 'murtes'),
            'validate' => 'numeric',
            'desc'     => 'Enter number',
            'msg'      => 'Please enter number',
            'default'  => ''
        ),
        array(
            'id'       => 'menu_letter_spacing',
            'type'     => 'text',
            'title'    => esc_html__('Letter Spacing', 'murtes'),
            'validate' => 'numeric',
            'desc'     => 'Enter number',
            'msg'      => 'Please enter number',
            'default'  => ''
        ),
        array(
            'id'       => 'menu_text_transform',
            'type'     => 'select',
            'title'    => esc_html__('Text Transform', 'murtes'),
            'options'  => array(
                ''  => esc_html__('Capitalize', 'murtes'),
                'uppercase' => esc_html__('Uppercase', 'murtes'),
                'lowercase'  => esc_html__('Lowercase', 'murtes'),
                'initial'  => esc_html__('Initial', 'murtes'),
                'inherit'  => esc_html__('Inherit', 'murtes'),
                'none'  => esc_html__('None', 'murtes'),
            ),
            'default'  => ''
        ),
        array(
            'id'      => 'main_menu_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Menu Item Color - First Level ( Main Menu )', 'murtes'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'   => '',
            ),
        ),
        array(
            'id'      => 'main_menu_color_sticky',
            'type'    => 'link_color',
            'title'   => esc_html__('Menu Item Color - First Level ( Sticky Menu )', 'murtes'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'   => '',
            ),
        ),
        array(
            'id'      => 'main_menu_color_sub',
            'type'    => 'link_color',
            'title'   => esc_html__('Menu Item Color - Sub Level', 'murtes'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'   => '',
            ),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Mobile', 'murtes'),
    'icon'       => 'el el-iphone-home',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'          => 'mobile_header_bgcolor',
            'type'        => 'color',
            'title'       => esc_html__('Header Background Color', 'murtes'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'          => 'mobile_icon_menu_color',
            'type'        => 'color',
            'title'       => esc_html__('Header Icon Menu Color', 'murtes'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'          => 'header_menu_bgcolor',
            'type'        => 'color',
            'title'       => esc_html__('Menu Background Color', 'murtes'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'      => 'main_menu_color_mobile',
            'type'    => 'link_color',
            'title'   => esc_html__('Menu Item Color', 'murtes'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'   => '',
            ),
        ),
        array(
            'id'       => 'search_on_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Search Icon', 'murtes'),
            'default'  => false
        ),
        array(
            'id'       => 'cart_on_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Cart Icon', 'murtes'),
            'default'  => false
        ),
    )
));

/*--------------------------------------------------------------
# Page Title area
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Page Title', 'murtes'),
    'icon'   => 'el-icon-map-marker',
    'fields' => array(
        array(
            'id'       => 'ptitle_on',
            'type'     => 'button_set',
            'title'    => esc_html__('Displayed', 'murtes'),
            'options'  => array(
                'show'  => esc_html__('Show', 'murtes'),
                'hidden'  => esc_html__('Hidden', 'murtes'),
            ),
            'default'  => 'show'
        ),
        array(
            'id'       => 'ptitle_bg',
            'type'     => 'background',
            'title'    => esc_html__('Background', 'murtes'),
            'subtitle' => esc_html__('Page title background color.', 'murtes'),
            'output'   => array('#pagetitle'),
            'background-color' => false,
            'required' => array( 0 => 'ptitle_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'pagetitle_bg_color',
            'type'     => 'color_rgba',
            'title'    => esc_html__('Background Color Overlay', 'murtes'),
            'output' => array('background-color' => '#pagetitle.bg-overlay:before'),
            'required' => array( 0 => 'ptitle_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'ptitle_color',
            'type'     => 'color',
            'title'    => esc_html__('Title Color', 'murtes'),
            'subtitle' => esc_html__('Page title color.', 'murtes'),
            'output'   => array('#pagetitle h1.page-title, #pagetitle h6.page-subtitle'),
            'default'  => '',
            'transparent' => false,
            'required' => array( 0 => 'ptitle_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'ptitle_breadcrumb_on',
            'type'     => 'button_set',
            'title'    => esc_html__('Breadcrumb', 'murtes'),
            'options'  => array(
                'show'  => esc_html__('Show', 'murtes'),
                'hidden'  => esc_html__('Hidden', 'murtes'),
            ),
            'default'  => 'show',
            'required' => array( 0 => 'ptitle_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'title' => esc_html__('Button', 'murtes'),
            'type'  => 'section',
            'id' => 'button_page_title',
            'indent' => true,
        ),
        array(
            'id' => 'p_btn_text',
            'type' => 'text',
            'title' => esc_html__('Button Text', 'murtes'),
            'default' => '',
        ),
        array(
            'id'       => 'p_btn_link_type',
            'type'     => 'button_set',
            'title'    => esc_html__('Button Link Type', 'murtes'),
            'options'  => array(
                'page'  => esc_html__('Page', 'murtes'),
                'custom'  => esc_html__('Custom', 'murtes')
            ),
            'default'  => 'page',
        ),
        array(
            'id'    => 'p_btn_link',
            'type'  => 'select',
            'title' => esc_html__( 'Page Link', 'murtes' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'p_btn_link_type', 1 => 'equals', 2 => 'page' ),
            'force_output' => true
        ),
        array(
            'id' => 'p_btn_link_custom',
            'type' => 'text',
            'title' => esc_html__('Custom Link', 'murtes'),
            'default' => '',
            'required' => array( 0 => 'p_btn_link_type', 1 => 'equals', 2 => 'custom' ),
            'force_output' => true
        ),
        array(
            'id'       => 'p_btn_target',
            'type'     => 'button_set',
            'title'    => esc_html__('Button Target', 'murtes'),
            'options'  => array(
                '_self'  => esc_html__('Self', 'murtes'),
                '_blank'  => esc_html__('Blank', 'murtes')
            ),
            'default'  => '_self',
        ),
    )
));

/*--------------------------------------------------------------
# WordPress default content
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title' => esc_html__('Content', 'murtes'),
    'icon'  => 'el-icon-pencil',
    'fields'     => array(
        array(
            'id'       => 'content_bg_color',
            'type'     => 'color_rgba',
            'title'    => esc_html__('Content Background Color', 'murtes'),
            'subtitle' => esc_html__('Content background color.', 'murtes'),
            'output' => array('background-color' => '#content')
        ),
        array(
            'id'       => 'sidebar_bg_color',
            'type'     => 'color_rgba',
            'title'    => esc_html__('Sidebar Background Color', 'murtes'),
            'subtitle' => esc_html__('Sidebar background color.', 'murtes'),
            'output' => array('background-color' => '.content-row #secondary.widget-has-sidebar::before')
        ),
        array(
            'id'             => 'content_padding',
            'type'           => 'spacing',
            'output'         => array('.site-content #primary, .site-content #secondary'),
            'right'   => false,
            'left'    => false,
            'mode'           => 'padding',
            'units'          => array('px'),
            'units_extended' => 'false',
            'title'          => esc_html__('Content Padding', 'murtes'),
            'desc'           => esc_html__('Default: Top-130px, Bottom-130px', 'murtes'),
            'default'            => array(
                'padding-top'   => '',
                'padding-bottom'   => '',
                'units'          => 'px',
            )
        ),
        array(
            'id'      => 'search_field_placeholder',
            'type'    => 'text',
            'title'   => esc_html__('Search Form - Text Placeholder', 'murtes'),
            'default' => '',
            'desc'           => esc_html__('Default: Search Keywords...', 'murtes'),
        ),
    )
));


Redux::setSection($opt_name, array(
    'title'      => esc_html__('Archive', 'murtes'),
    'icon'       => 'el-icon-list',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'archive_sidebar_pos',
            'type'     => 'button_set',
            'title'    => esc_html__('Sidebar Position', 'murtes'),
            'subtitle' => esc_html__('Select a sidebar position for blog home, archive, search...', 'murtes'),
            'options'  => array(
                'left'  => esc_html__('Left', 'murtes'),
                'right' => esc_html__('Right', 'murtes'),
                'none'  => esc_html__('Disabled', 'murtes')
            ),
            'default'  => 'right'
        ),
        array(
            'id'       => 'archive_author_on',
            'title'    => esc_html__('Author', 'murtes'),
            'subtitle' => esc_html__('Show author name on each post.', 'murtes'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_date_on',
            'title'    => esc_html__('Date', 'murtes'),
            'subtitle' => esc_html__('Show date posted on each post.', 'murtes'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_comment_on',
            'title'    => esc_html__('Comment', 'murtes'),
            'subtitle' => esc_html__('Show comment posted on each post.', 'murtes'),
            'type'     => 'switch',
            'default'  => true,
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Single Post', 'murtes'),
    'icon'       => 'el-icon-file-edit',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'post_sidebar_pos',
            'type'     => 'button_set',
            'title'    => esc_html__('Sidebar Position', 'murtes'),
            'subtitle' => esc_html__('Select a sidebar position', 'murtes'),
            'options'  => array(
                'left'  => esc_html__('Left', 'murtes'),
                'right' => esc_html__('Right', 'murtes'),
                'none'  => esc_html__('Disabled', 'murtes')
            ),
            'default'  => 'right'
        ),
        array(
            'id'       => 'post_text_align',
            'type'     => 'button_set',
            'title'    => esc_html__('Text Align', 'murtes'),
            'options'  => array(
                'inherit'  => esc_html__('Inherit', 'murtes'),
                'justify'  => esc_html__('Justify', 'murtes'),
            ),
            'default'  => 'inherit'
        ),
        array(
            'id'       => 'post_author_on',
            'title'    => esc_html__('Author', 'murtes'),
            'subtitle' => esc_html__('Show author name on single post.', 'murtes'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_date_on',
            'title'    => esc_html__('Date', 'murtes'),
            'subtitle' => esc_html__('Show date on single post.', 'murtes'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_comment_on',
            'title'    => esc_html__('Comment', 'murtes'),
            'subtitle' => esc_html__('Show comment on single post.', 'murtes'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'post_tags_on',
            'title'    => esc_html__('Tags', 'murtes'),
            'subtitle' => esc_html__('Show tags count on single post.', 'murtes'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_social_share_on',
            'title'    => esc_html__('Social Share', 'murtes'),
            'subtitle' => esc_html__('Show social share on single post.', 'murtes'),
            'type'     => 'switch',
            'default'  => false,
        ),
        array(
            'id'       => 'post_comments_form_on',
            'title'    => esc_html__('Comments Form', 'murtes'),
            'subtitle' => esc_html__('Show comments form on single post.', 'murtes'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_related',
            'title'    => esc_html__('Related', 'murtes'),
            'subtitle' => esc_html__('Show related post info on single post.', 'murtes'),
            'type'     => 'switch',
            'default'  => false
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Extra Post Type', 'murtes'),
    'icon'       => 'el el-cog ',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'      => 'case_study_name',
            'type'    => 'text',
            'title'   => esc_html__('Case Study Name', 'murtes'),
            'default' => '',
            'desc'     => 'Default: Case Study',
        ),
        array(
            'id'      => 'case_study_slug',
            'type'    => 'text',
            'title'   => esc_html__('Case Study Slug', 'murtes'),
            'default' => '',
            'desc'     => 'Default: case-study',
        ),
        array(
            'id'      => 'service_slug',
            'type'    => 'text',
            'title'   => esc_html__('Service Slug', 'murtes'),
            'default' => '',
            'desc'     => 'Default: service',
        ),
    )
));

/*--------------------------------------------------------------
# Footer
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Footer', 'murtes'),
    'icon'   => 'el el-website',
    'fields' => array(
        array(
            'id'       => 'footer_layout',
            'type'     => 'image_select',
            'title'    => esc_html__('Layout', 'murtes'),
            'subtitle' => esc_html__('Select a layout for footer.', 'murtes'),
            'options'  => array(
                '1' => get_template_directory_uri() . '/assets/images/footer-layout/f1.jpg',
                'custom' => get_template_directory_uri() . '/assets/images/footer-layout/custom.jpg',
            ),
            'default'  => '1'
        ),
        array(
            'id'          => 'footer_layout_custom',
            'type'        => 'select',
            'title'       => esc_html__('Custom Layout', 'murtes'),
            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your custom footer layout first.','murtes'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=footer' ) ) . '">','</a>'),
            'options'     =>murtes_list_post('footer'),
            'default'     => '',
            'required' => array( 0 => 'footer_layout', 1 => 'equals', 2 => 'custom' ),
            'force_output' => true
        ),
        array(
            'id'       => 'back_totop_on',
            'type'     => 'switch',
            'title'    => esc_html__('Back to Top Button', 'murtes'),
            'subtitle' => esc_html__('Show back to top button when scrolled down.', 'murtes'),
            'default'  => true,
        ),
        array(
            'id'       => 'cta',
            'type'     => 'button_set',
            'title'    => esc_html__('Call To Action', 'murtes'),
            'options'  => array(
                'show'  => esc_html__('Show', 'murtes'),
                'hidden'  => esc_html__('Hidden', 'murtes'),
            ),
            'default'  => 'hidden'
        ),
        array(
            'id'      => 'cta_subtitle',
            'type'    => 'text',
            'title'   => esc_html__('CTA Sub Title', 'murtes'),
            'default' => '',
            'required' => array( 0 => 'cta', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'      => 'cta_title',
            'type'    => 'text',
            'title'   => esc_html__('CTA Title', 'murtes'),
            'default' => '',
            'required' => array( 0 => 'cta', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'      => 'cta_btn_text',
            'type'    => 'text',
            'title'   => esc_html__('CTA Button Text', 'murtes'),
            'default' => '',
            'required' => array( 0 => 'cta', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'      => 'cta_btn_link',
            'type'    => 'text',
            'title'   => esc_html__('CTA Button Link', 'murtes'),
            'default' => '',
            'required' => array( 0 => 'cta', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'cta_btn_target',
            'type'     => 'button_set',
            'title'    => esc_html__('CTA Button Target', 'murtes'),
            'options'  => array(
                '_self'  => esc_html__('Self', 'murtes'),
                '_blank'  => esc_html__('Blank', 'murtes')
            ),
            'default'  => '_self',
            'required' => array( 0 => 'cta', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'      => 'cta_text_outline',
            'type'    => 'text',
            'title'   => esc_html__('Text Outline', 'murtes'),
            'default' => '',
            'required' => array( 0 => 'cta', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Footer Top', 'murtes'),
    'icon'       => 'el el-th-large',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'footer_top_bg',
            'type'     => 'background',
            'title'    => esc_html__('Background', 'murtes'),
            'subtitle' => esc_html__('Footer background.', 'murtes'),
            'output'   => array('.site-footer .top-footer'),
            'background-color' => false,
            'transparent' => false,
            'required' => array('footer_layout', '!=', 'custom'),
            'force_output' => true,
        ),
        array(
            'id'       => 'footer_top_column',
            'type'     => 'button_set',
            'title'    => esc_html__('Columns', 'murtes'),
            'options'  => array(
                '1'  => esc_html__('1 Column', 'murtes'),
                '2'  => esc_html__('2 Column', 'murtes'),
                '3'  => esc_html__('3 Column', 'murtes'),
                '4'  => esc_html__('4 Column', 'murtes'),
            ),
            'default'  => '4',
            'required' => array('footer_layout', '!=', 'custom'),
            'force_output' => true
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Footer Bottom', 'murtes'),
    'icon'       => 'el el-th-large',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'footer_bottom_bg',
            'type'     => 'background',
            'title'    => esc_html__('Background', 'murtes'),
            'subtitle' => esc_html__('Footer background.', 'murtes'),
            'output'   => array('.site-footer .bottom-footer'),
            'background-image' => false,
            'background-repeat' => false,
            'background-position' => false,
            'background-attachment' => false,
            'background-size' => false,
            'transparent' => false,
            'required' => array('footer_layout', '!=', 'custom'),
            'force_output' => true
        ),
        array(
            'id'=>'footer_copyright',
            'type' => 'textarea',
            'title' => esc_html__('Footer Bottom Copyright', 'murtes'),
            'validate' => 'html_custom',
            'default' => '',
            'subtitle' => esc_html__('Custom HTML Allowed: a,br,em,strong,span,p,div,h1->h6,[ct_year]', 'murtes'),
            'allowed_html' => array(
                'a' => array(
                    'href' => array(),
                    'title' => array(),
                    'class' => array(),
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array(),
                'span' => array(),
                'p' => array(),
                'div' => array(
                    'class' => array()
                ),
                'h1' => array(
                    'class' => array()
                ),
                'h2' => array(
                    'class' => array()
                ),
                'h3' => array(
                    'class' => array()
                ),
                'h4' => array(
                    'class' => array()
                ),
                'h5' => array(
                    'class' => array()
                ),
                'h6' => array(
                    'class' => array()
                ),
                'ul' => array(
                    'class' => array()
                ),
                'li' => array(),
            ),
            'required' => array('footer_layout', '!=', 'custom'),
            'force_output' => true
        ),
    )
));

/* 404 Page /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('404 Page', 'murtes'),
    'icon'   => 'el-cog-alt el',
    'fields' => array(

        array(
            'id'       => 'content_404',
            'type'     => 'text',
            'title'    => esc_html__('Content', 'murtes'),
            'default' => '',
        ),
        array(
            'id'       => 'btn_text_404_page',
            'type'     => 'text',
            'title'    => esc_html__('Button Text', 'murtes'),
            'default' => '',
        ),
    ),
));


/*--------------------------------------------------------------
# Colors
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Colors', 'murtes'),
    'icon'   => 'el-icon-file-edit',
    'fields' => array(
        array(
            'title' => esc_html__('Color Main', 'murtes'),
            'type'  => 'section',
            'id' => 'color_main',
            'indent' => true,
        ),
        array(
            'id'          => 'primary_color',
            'type'        => 'color',
            'title'       => esc_html__('Primary Color', 'murtes'),
            'transparent' => false,
            'default'     => '#0064eb'
        ),
        array(
            'id'          => 'gradient_color',
            'type'        => 'color_gradient',
            'title'       => esc_html__('Gradient Color', 'murtes'),
            'transparent' => false,
            'default'  => array(
                'from' => '#005cea',
                'to'   => '#00c5fb', 
            ),
        ),
        array(
            'id'          => 'secondary_color',
            'type'        => 'color',
            'title'       => esc_html__('Secondary Color', 'murtes'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'      => 'link_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Link Colors', 'murtes'),
            'default' => array(
                'regular' => '#0064eb',
                'hover'   => '#00c5fb',
                'active'  => '#00c5fb'
            ),
            'output'  => array('a')
        ),
    )
));

/*--------------------------------------------------------------
# Typography
--------------------------------------------------------------*/
$custom_font_selectors_1 = Redux::get_option($opt_name, 'custom_font_selectors_1');
$custom_font_selectors_1 = !empty($custom_font_selectors_1) ? explode(',', $custom_font_selectors_1) : array();
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Typography', 'murtes'),
    'icon'   => 'el-icon-text-width',
    'fields' => array(
        array(
            'id'       => 'body_default_font',
            'type'     => 'select',
            'title'    => esc_html__('Body Default Font', 'murtes'),
            'options'  => array(
                'Montserrat'  => esc_html__('Default', 'murtes'),
                'Google-Font'  => esc_html__('Google Font', 'murtes'),
            ),
            'default'  => 'Montserrat',
        ),
        array(
            'id'          => 'font_main',
            'type'        => 'typography',
            'title'       => esc_html__('Body Google Font', 'murtes'),
            'subtitle'    => esc_html__('This will be the default font of your website.', 'murtes'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'line-height'  => true,
            'font-size'  => true,
            'text-align'  => false,
            'color'  => false,
            'output'      => array('body'),
            'units'       => 'px',
            'required' => array( 0 => 'body_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'body_color',
            'type'        => 'color',
            'title'       => esc_html__('Body Color', 'murtes'),
            'transparent' => false,
            'default'     => '',
            'required' => array( 0 => 'body_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true,
            'output'      => array('body, .single-hentry.archive .entry-content, .single-post .content-area, .ct-related-post .item-holder .item-content'),
        ),
        array(
            'id'       => 'heading_default_font',
            'type'     => 'select',
            'title'    => esc_html__('Heading Default Font', 'murtes'),
            'options'  => array(
                'Montserrat'  => esc_html__('Default', 'murtes'),
                'Google-Font'  => esc_html__('Google Font', 'murtes'),
            ),
            'default'  => 'Montserrat',
        ),
        array(
            'id'          => 'font_h1',
            'type'        => 'typography',
            'title'       => esc_html__('H1', 'murtes'),
            'subtitle'    => esc_html__('This will be the default font for all H1 tags of your website.', 'murtes'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'color'  => false,
            'output'      => array('h1', '.h1', '.text-heading'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h2',
            'type'        => 'typography',
            'title'       => esc_html__('H2', 'murtes'),
            'subtitle'    => esc_html__('This will be the default font for all H2 tags of your website.', 'murtes'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'color'  => false,
            'output'      => array('h2', '.h2'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h3',
            'type'        => 'typography',
            'title'       => esc_html__('H3', 'murtes'),
            'subtitle'    => esc_html__('This will be the default font for all H3 tags of your website.', 'murtes'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'color'  => false,
            'output'      => array('h3', '.h3'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h4',
            'type'        => 'typography',
            'title'       => esc_html__('H4', 'murtes'),
            'subtitle'    => esc_html__('This will be the default font for all H4 tags of your website.', 'murtes'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'color'  => false,
            'output'      => array('h4', '.h4'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h5',
            'type'        => 'typography',
            'title'       => esc_html__('H5', 'murtes'),
            'subtitle'    => esc_html__('This will be the default font for all H5 tags of your website.', 'murtes'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'color'  => false,
            'output'      => array('h5', '.h5'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h6',
            'type'        => 'typography',
            'title'       => esc_html__('H6', 'murtes'),
            'subtitle'    => esc_html__('This will be the default font for all H6 tags of your website.', 'murtes'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'color'  => false,
            'output'      => array('h6', '.h6'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        )
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Fonts Selectors', 'murtes'),
    'icon'       => 'el el-fontsize',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'          => 'custom_font_1',
            'type'        => 'typography',
            'title'       => esc_html__('Custom Font', 'murtes'),
            'subtitle'    => esc_html__('This will be the font that applies to the class selector.', 'murtes'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => $custom_font_selectors_1,
            'units'       => 'px',

        ),
        array(
            'id'       => 'custom_font_selectors_1',
            'type'     => 'textarea',
            'title'    => esc_html__('CSS Selectors', 'murtes'),
            'subtitle' => esc_html__('Add class selectors to apply above font.', 'murtes'),
            'validate' => 'no_html'
        )
    )
));

/*--------------------------------------------------------------
# Social Link
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Social Link', 'murtes'),
    'icon'   => 'el el-share',
    'fields' => array(
        array(
            'id'      => 'social_facebook_url',
            'type'    => 'text',
            'title'   => esc_html__('Facebook URL', 'murtes'),
            'default' => '',
        ),
        array(
            'id'      => 'social_twitter_url',
            'type'    => 'text',
            'title'   => esc_html__('Twitter URL', 'murtes'),
            'default' => '',
        ),
        array(
            'id'      => 'social_inkedin_url',
            'type'    => 'text',
            'title'   => esc_html__('Inkedin URL', 'murtes'),
            'default' => '',
        ),
        array(
            'id'      => 'social_instagram_url',
            'type'    => 'text',
            'title'   => esc_html__('Instagram URL', 'murtes'),
            'default' => '',
        ),
        array(
            'id'      => 'social_google_url',
            'type'    => 'text',
            'title'   => esc_html__('Google URL', 'murtes'),
            'default' => '',
        ),
        array(
            'id'      => 'social_skype_url',
            'type'    => 'text',
            'title'   => esc_html__('Skype URL', 'murtes'),
            'default' => '',
        ),
        array(
            'id'      => 'social_pinterest_url',
            'type'    => 'text',
            'title'   => esc_html__('Pinterest URL', 'murtes'),
            'default' => '',
        ),
        array(
            'id'      => 'social_vimeo_url',
            'type'    => 'text',
            'title'   => esc_html__('Vimeo URL', 'murtes'),
            'default' => '',
        ),
        array(
            'id'      => 'social_youtube_url',
            'type'    => 'text',
            'title'   => esc_html__('Youtube URL', 'murtes'),
            'default' => '',
        ),
        array(
            'id'      => 'social_yelp_url',
            'type'    => 'text',
            'title'   => esc_html__('Yelp URL', 'murtes'),
            'default' => '',
        ),
        array(
            'id'      => 'social_tumblr_url',
            'type'    => 'text',
            'title'   => esc_html__('Tumblr URL', 'murtes'),
            'default' => '',
        ),
        array(
            'id'      => 'social_tripadvisor_url',
            'type'    => 'text',
            'title'   => esc_html__('Tripadvisor URL', 'murtes'),
            'default' => '',
        ),
    )
));

/*--------------------------------------------------------------
# Shop
--------------------------------------------------------------*/
if(class_exists('Woocommerce')) {
    Redux::setSection($opt_name, array(
        'title'  => esc_html__('Shop', 'murtes'),
        'icon'   => 'el el-shopping-cart',
        'fields' => array(
            array(
                'id'       => 'sidebar_shop',
                'type'     => 'button_set',
                'title'    => esc_html__('Sidebar Position', 'murtes'),
                'subtitle' => esc_html__('Select a sidebar position for archive shop.', 'murtes'),
                'options'  => array(
                    'left'  => esc_html__('Left', 'murtes'),
                    'right' => esc_html__('Right', 'murtes'),
                    'none'  => esc_html__('Disabled', 'murtes')
                ),
                'default'  => 'left'
            ),
            array(
                'title' => esc_html__('Products displayed per page', 'murtes'),
                'id' => 'product_per_page',
                'type' => 'slider',
                'subtitle' => esc_html__('Number product to show', 'murtes'),
                'default' => 12,
                'min'  => 6,
                'step' => 1,
                'max' => 50,
                'display_value' => 'text'
            ),
            array(
                'id'       => 'shop_content_padding',
                'type'     => 'spacing',
                'title'    => esc_html__('Content Paddings', 'murtes'),
                'subtitle' => esc_html__('Content paddings.', 'murtes'),
                'mode'     => 'padding',
                'units'    => array('em', 'px', '%'),
                'top'      => true,
                'right'    => false,
                'bottom'   => true,
                'left'     => false,
                'output'   => array('.woocommerce #content, .woocommerce-page #content'),
                'default'  => array(
                    'top'    => '',
                    'right'  => '',
                    'bottom' => '',
                    'left'   => '',
                    'units'  => 'px',
                )
            ),
            array(
                'id'       => 'product_social_share',
                'title'    => esc_html__('Product Social Share', 'murtes'),
                'type'     => 'switch',
                'default'  => false,
            ),
        )
    ));
}
/* Custom Code /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Custom Code', 'murtes'),
    'icon'   => 'el-icon-edit',
    'fields' => array(

        array(
            'id'       => 'site_header_code',
            'type'     => 'textarea',
            'theme'    => 'chrome',
            'title'    => esc_html__('Scripts in Header', 'murtes'),
            'subtitle' => esc_html__('These scripts will be printed in the <head> section.', 'murtes'),
        ),
        array(
            'id'       => 'site_footer_code',
            'type'     => 'textarea',
            'theme'    => 'chrome',
            'title'    => esc_html__('Scripts in Footer', 'murtes'),
            'subtitle' => esc_html__('These scripts will be printed above the </body> tag.', 'murtes'),
        ),

    ),
));

/* Custom CSS /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Custom CSS', 'murtes'),
    'icon'   => 'el-icon-adjust-alt',
    'fields' => array(

        array(
            'id'   => 'customcss',
            'type' => 'info',
            'desc' => esc_html__('Custom CSS', 'murtes')
        ),

        array(
            'id'       => 'site_css',
            'type'     => 'ace_editor',
            'title'    => esc_html__('CSS Code', 'murtes'),
            'subtitle' => esc_html__('Advanced CSS Options. You can paste your custom CSS Code here.', 'murtes'),
            'mode'     => 'css',
            'validate' => 'css',
            'theme'    => 'chrome',
            'default'  => ""
        ),

    ),
));