<?php
/**
 * Register metabox for posts based on Redux Framework. Supported methods:
 *     isset_args( $post_type )
 *     set_args( $post_type, $redux_args, $metabox_args )
 *     add_section( $post_type, $sections )
 * Each post type can contains only one metabox. Pease note that each field id
 * leads by an underscore sign ( _ ) in order to not show that into Custom Field
 * Metabox from WordPress core feature.
 *
 * @param murtes_Post_Metabox $metabox
 */

/**
 * Get list menu.
 * @return array
 */
function murtes_get_nav_menu(){

    $menus = array(
        '' => esc_html__('Default', 'murtes')
    );

    $obj_menus = wp_get_nav_menus();

    foreach ($obj_menus as $obj_menu){
        $menus[$obj_menu->term_id] = $obj_menu->name;
    }

    return $menus;
}

function murtes_page_options_register( $metabox ) {
	if ( ! $metabox->isset_args( 'post' ) ) {
		$metabox->set_args( 'post', array(
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Settings', 'murtes' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'page' ) ) {
		$metabox->set_args( 'page', array(
			'opt_name'            =>murtes_get_page_opt_name(),
			'display_name'        => esc_html__( 'Page Settings', 'murtes' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_audio' ) ) {
		$metabox->set_args( 'cms_pf_audio', array(
			'opt_name'     => 'post_format_audio',
			'display_name' => esc_html__( 'Audio', 'murtes' ),
			'class'        => 'fully-expanded',
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_link' ) ) {
		$metabox->set_args( 'cms_pf_link', array(
			'opt_name'     => 'post_format_link',
			'display_name' => esc_html__( 'Link', 'murtes' )
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_quote' ) ) {
		$metabox->set_args( 'cms_pf_quote', array(
			'opt_name'     => 'post_format_quote',
			'display_name' => esc_html__( 'Quote', 'murtes' )
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_video' ) ) {
		$metabox->set_args( 'cms_pf_video', array(
			'opt_name'     => 'post_format_video',
			'display_name' => esc_html__( 'Video', 'murtes' ),
			'class'        => 'fully-expanded',
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_gallery' ) ) {
		$metabox->set_args( 'cms_pf_gallery', array(
			'opt_name'     => 'post_format_gallery',
			'display_name' => esc_html__( 'Gallery', 'murtes' ),
			'class'        => 'fully-expanded',
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	/* Extra Post Type */
	if ( ! $metabox->isset_args( 'case-study' ) ) {
		$metabox->set_args( 'case-study', array(
			'opt_name'            => 'case-study_option',
			'display_name'        => esc_html__( 'Case Study Settings', 'murtes' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}
	if ( ! $metabox->isset_args( 'service' ) ) {
		$metabox->set_args( 'service', array(
			'opt_name'            => 'service_option',
			'display_name'        => esc_html__( 'Service Settings', 'murtes' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	/**
	 * Config Case Study meta options
	 *
	 */

	$metabox->add_section( 'case-study', array(
		'title'  => esc_html__( 'General', 'murtes' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'    => 'case_study_excerpt',
				'type'  => 'textarea',
				'title' => esc_html__( 'Excerpt', 'murtes' )
			),
			array(
				'id'             => 'content_padding',
				'type'           => 'spacing',
				'output'         => array( '.single-case-study .site-content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'murtes' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'murtes' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				)
			),
		)
	) );

	/**
	 * Config service meta options
	 *
	 */

	$metabox->add_section( 'service', array(
		'title'  => esc_html__( 'General', 'murtes' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'    => 'service_excerpt',
				'type'  => 'textarea',
				'title' => esc_html__( 'Excerpt', 'murtes' )
			),
			array(
				'id'             => 'content_padding',
				'type'           => 'spacing',
				'output'         => array( '.single-service .site-content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'murtes' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'murtes' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				)
			),
			array(
				'id'          => 'link_custom',
				'type'        => 'text',
				'title'       => esc_html__( 'Link Custom', 'murtes' ),
				'validate'    => 'url',
				'msg'         => 'Url error!'
			)
		)
	) );

	/**
	 * Config post blog meta options
	 *
	 */
	$metabox->add_section( 'post', array(
		'title'  => esc_html__( 'General', 'murtes' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'      => 'show_sidebar_post',
				'type'    => 'switch',
				'title'   => esc_html__( 'Custom Sidebar', 'murtes' ),
				'default' => false,
				'indent'  => true
			),
			array(
				'id'           => 'sidebar_post_pos',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Sidebar Position', 'murtes' ),
				'options'      => array(
					'left'  => esc_html__('Left', 'murtes'),
	                'right' => esc_html__('Right', 'murtes'),
	                'none'  => esc_html__('Disabled', 'murtes')
				),
				'default'      => 'right',
				'required'     => array( 0 => 'show_sidebar_post', 1 => '=', 2 => '1' ),
				'force_output' => true
			),
		)
	) );

	/**
	 * Config page meta options
	 *
	 */

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Header', 'murtes' ),
		'desc'   => esc_html__( 'Header settings for the page.', 'murtes' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'      => 'custom_header',
				'type'    => 'switch',
				'title'   => esc_html__( 'Custom Layout', 'murtes' ),
				'default' => false,
				'indent'  => true
			),
			array(
				'id'           => 'header_layout',
				'type'         => 'image_select',
				'title'        => esc_html__( 'Layout', 'murtes' ),
				'subtitle'     => esc_html__( 'Select a layout for header.', 'murtes' ),
				'options'      => array(
					'0' => get_template_directory_uri() . '/assets/images/header-layout/h0.jpg',
					'1' => get_template_directory_uri() . '/assets/images/header-layout/h1.jpg',
					'2' => get_template_directory_uri() . '/assets/images/header-layout/h2.jpg',
					'3' => get_template_directory_uri() . '/assets/images/header-layout/h3.jpg',
					'4' => get_template_directory_uri() . '/assets/images/header-layout/h4.jpg',
					'5' => get_template_directory_uri() . '/assets/images/header-layout/h5.jpg',
				),
				'default'      =>murtes_get_option_of_theme_options( 'header_layout' ),
				'required'     => array( 0 => 'custom_header', 1 => 'equals', 2 => '1' ),
				'force_output' => true
			),
		)
	) );

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Page Title', 'murtes' ),
		'icon'   => 'el-icon-map-marker',
		'fields' => array(
			array(
	            'id'       => 'ptitle_on',
	            'type'     => 'button_set',
	            'title'    => esc_html__('Displayed', 'murtes'),
	            'options'  => array(
	                'themeoption'  => esc_html__('Theme Option', 'murtes'),
	                'show'  => esc_html__('Show', 'murtes'),
	                'hidden'  => esc_html__('Hidden', 'murtes'),
	            ),
	            'default'  => 'themeoption'
	        ),
	        array(
				'id'           => 'custom_title',
				'type'         => 'text',
				'title'        => esc_html__( 'Title', 'murtes' ),
				'subtitle'     => esc_html__( 'Use custom title for this page. The default title will be used on document title.', 'murtes' ),
				'required' => array('ptitle_on', '!=', 'hidden'),
			),
	        array(
	            'id'       => 'ptitle_bg',
	            'type'     => 'background',
	            'title'    => esc_html__('Background', 'murtes'),
	            'subtitle' => esc_html__('Page title background color.', 'murtes'),
	            'output'   => array('body #pagetitle'),
	            'background-color' => false,
	            'required' => array('ptitle_on', '!=', 'hidden'),
	        ),
		)
	) );

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Content', 'murtes' ),
		'desc'   => esc_html__( 'Settings for content area.', 'murtes' ),
		'icon'   => 'el-icon-pencil',
		'fields' => array(
			array(
				'id'       => 'content_bg_color',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Background Color', 'murtes' ),
				'subtitle' => esc_html__( 'Content background color.', 'murtes' ),
				'output'   => array( 'background-color' => '#content, .site-layout-default .site-footer:before' )
			),
			array(
				'id'             => 'content_padding',
				'type'           => 'spacing',
				'output'         => array( 'body .site-content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'murtes' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'murtes' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				)
			),
			array(
				'id'      => 'show_sidebar_page',
				'type'    => 'switch',
				'title'   => esc_html__( 'Show Sidebar', 'murtes' ),
				'default' => false,
				'indent'  => true
			),
			array(
				'id'           => 'sidebar_page_pos',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Sidebar Position', 'murtes' ),
				'options'      => array(
					'left'  => esc_html__( 'Left', 'murtes' ),
					'right' => esc_html__( 'Right', 'murtes' ),
				),
				'default'      => 'right',
				'required'     => array( 0 => 'show_sidebar_page', 1 => '=', 2 => '1' ),
				'force_output' => true
			),
		)
	) );

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Footer', 'murtes' ),
		'desc'   => esc_html__( 'Settings for footer area.', 'murtes' ),
		'icon'   => 'el el-website',
		'fields' => array(
			array(
				'id'      => 'custom_footer',
				'type'    => 'switch',
				'title'   => esc_html__( 'Custom Layout', 'murtes' ),
				'default' => false,
				'indent'  => true
			),
			array(
            	'id'       => 'footer_layout',
	            'type'     => 'image_select',
	            'title'    => esc_html__('Layout', 'murtes'),
	            'subtitle' => esc_html__('Select a layout for footer.', 'murtes'),
	            'options'  => array(
	                '1' => get_template_directory_uri() . '/assets/images/footer-layout/f1.jpg',
	                'custom' => get_template_directory_uri() . '/assets/images/footer-layout/custom.jpg',
	            ),
	            'default'  => '1',
	            'required' => array( 0 => 'custom_footer', 1 => 'equals', 2 => '1' ),
	            'force_output' => true
	        ),
	        array(
	            'id'          => 'footer_layout_custom',
	            'type'        => 'select',
	            'title'       => esc_html__('Custom Layout', 'murtes'),
	            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your custom footer layout first.','murtes'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=footer' ) ) . '">','</a>'),
	            'options'     =>murtes_list_post('footer'),
	            'default'     => '',
	            'required' => array( 0 => 'footer_layout', 1 => 'equals', 2 => 'custom' ),
	            'force_output' => true
	        ),
	        array(
	            'id'       => 'cta_page',
	            'type'     => 'button_set',
	            'title'    => esc_html__('Call To Action', 'murtes'),
	            'options'  => array(
	                'themeoption'  => esc_html__('Theme Option', 'murtes'),
	                'show'  => esc_html__('Show', 'murtes'),
	                'hidden'  => esc_html__('Hidden', 'murtes'),
	            ),
	            'default'  => 'themeoption'
	        ),
	    )
	) );

	/**
	 * Config post format meta options
	 *
	 */

	$metabox->add_section( 'cms_pf_video', array(
		'title'  => esc_html__( 'Video', 'murtes' ),
		'fields' => array(
			array(
				'id'    => 'post-video-url',
				'type'  => 'text',
				'title' => esc_html__( 'Video URL', 'murtes' ),
				'desc'  => esc_html__( 'YouTube or Vimeo video URL', 'murtes' )
			),
		)
	) );

	$metabox->add_section( 'cms_pf_gallery', array(
		'title'  => esc_html__( 'Gallery', 'murtes' ),
		'fields' => array(
			array(
				'id'       => 'post-gallery-lightbox',
				'type'     => 'switch',
				'title'    => esc_html__( 'Lightbox?', 'murtes' ),
				'subtitle' => esc_html__( 'Enable lightbox for gallery images.', 'murtes' ),
				'default'  => true
			),
			array(
				'id'       => 'post-gallery-images',
				'type'     => 'gallery',
				'title'    => esc_html__( 'Gallery Images ', 'murtes' ),
				'subtitle' => esc_html__( 'Upload images or add from media library.', 'murtes' )
			)
		)
	) );

	$metabox->add_section( 'cms_pf_audio', array(
		'title'  => esc_html__( 'Audio', 'murtes' ),
		'fields' => array(
			array(
				'id'          => 'post-audio-url',
				'type'        => 'text',
				'title'       => esc_html__( 'SoundCloud URL', 'murtes' ),
				'validate'    => 'url',
				'msg'         => 'Url error!'
			)
		)
	) );

	$metabox->add_section( 'cms_pf_link', array(
		'title'  => esc_html__( 'Link', 'murtes' ),
		'fields' => array(
			array(
				'id'       => 'post-link-url',
				'type'     => 'text',
				'title'    => esc_html__( 'URL', 'murtes' ),
				'validate' => 'url',
				'msg'      => 'Url error!'
			)
		)
	) );

	$metabox->add_section( 'cms_pf_quote', array(
		'title'  => esc_html__( 'Quote Settings', 'murtes' ),
		'fields' => array(
			array(
				'id'    => 'post-quote',
				'type'  => 'textarea',
				'title' => esc_html__( 'Quote', 'murtes' )
			)
		)
	) );

}


add_action( 'cms_post_metabox_register', 'murtes_page_options_register' );

function murtes_get_option_of_theme_options( $key, $default = '' ) {
	if ( empty( $key ) ) {
		return;
	}
	$options = get_option(murtes_get_opt_name(), array() );
	$value   = isset( $options[ $key ] ) ? $options[ $key ] : $default;

	return $value;
}