<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package Murtes
 */

get_header(); 

$content_404 = murtes_get_opt( 'content_404' );
$btn_text_404_page = murtes_get_opt( 'btn_text_404_page' );
?>

    <div class="error-holder">
        <div class="error-number">404<span>404</span></div>
        <div class="error-content">
            <?php if(!empty($content_404)) { 
                echo esc_attr($content_404); 
            } else { 
                echo '<span>Oops!</span> Sorry this page is not found.'; 
            } ?>
        </div>
        <a class="btn btn-secondary" href="<?php echo esc_url(home_url('/')); ?>">
            <i class="fac fac-long-arrow-alt-left icon-left"></i><?php if(!empty($btn_text_404_page)) { echo esc_attr($btn_text_404_page); } else { echo esc_html__('Back to home', 'murtes'); } ?>
        </a>
        <div class="error-image"><img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/image-404.jpg'); ?>" alt="<?php echo esc_attr__('Image 404', 'murtes'); ?>" /></div>
    </div>

<?php
get_footer();
